-- paintAnywhere 
-- by modelleicher 28.11.2021
-- allows to terraform, paint ground and foliage anywhere

-- Update 16.11.2022 - remove all collisions from Landscaping Brush so landscaping below triggers and vehicles is also possible 

paintAndTerraformAnywhere = {};

-- remove dynamic and vehicle collisions from Landscaping Brush 
CollisionMask.LANDSCAPING = 0

-- this seems to very if access is possible for every paint and landscape operation
function paintAndTerraformAnywhere.verifyAccess(self, superFunc, a, b, c)
	return nil;
end;
ConstructionBrush.verifyAccess = Utils.overwrittenFunction(ConstructionBrush.verifyAccess, paintAndTerraformAnywhere.verifyAccess);

-- this also seems to stop painting and terraforming on not-owned land
function paintAndTerraformAnywhere.isModificationAreaOnOwnedLand(...)
	return true;
end;
Landscaping.isModificationAreaOnOwnedLand = Utils.overwrittenFunction(Landscaping.isModificationAreaOnOwnedLand, paintAndTerraformAnywhere.isModificationAreaOnOwnedLand);

-- not sure what this prevents as it didn't allow for terraforming through placeables
function paintAndTerraformAnywhere.hasObjectOverlapInModificationArea(...)
	return false;
end;
Landscaping.hasObjectOverlapInModificationArea = Utils.overwrittenFunction(Landscaping.hasObjectOverlapInModificationArea, paintAndTerraformAnywhere.hasObjectOverlapInModificationArea);

-- this allows terraforming through placeables and objects, roads and stuff 
function paintAndTerraformAnywhere.setBlockedAreaMap(...) end;
TerrainDeformation.setBlockedAreaMap = Utils.overwrittenFunction(TerrainDeformation.setBlockedAreaMap, paintAndTerraformAnywhere.setBlockedAreaMap);

