ColorConfiguratorSaveDialog = {
	CONTROLS = {
		"multiSaveOption"
	},
	L10N_SYMBOL = {
		CONFIGURATION = "colorConfigurator_ui_saveTo_configuration",
		CONFIGURATOR = "colorConfigurator_ui_saveTo_configurator",
		DEFAULT_COLOR_NAME = "colorConfigurator_ui_defaultColorName"
	},
	SAVE_STATE = {
		VEHICLE = 1,
		GLOBAL = 2
	}
}

local ColorConfiguratorSaveDialog_mt = Class(ColorConfiguratorSaveDialog, TextInputDialog)

function ColorConfiguratorSaveDialog.new(target, custom_mt, colorConfigurator)
	local self = TextInputDialog.new(target, custom_mt or ColorConfiguratorSaveDialog_mt)

	self:registerControls(ColorConfiguratorSaveDialog.CONTROLS)

	self.colorConfigurator = colorConfigurator

	self.isVehicleConfig = true
	self.onTextEntered = nil
	self.isPasswordDialog = false
	self.disableFilter = false
	self.textSample = nil

	return self
end

function ColorConfiguratorSaveDialog:onGuiSetupFinished()
	ColorConfiguratorSaveDialog:superClass().onGuiSetupFinished(self)

	self.multiSaveOption:setTexts({
		g_i18n:getText(ColorConfiguratorSaveDialog.L10N_SYMBOL.CONFIGURATION),
		g_i18n:getText(ColorConfiguratorSaveDialog.L10N_SYMBOL.CONFIGURATOR)
	})

	self.textElement.customFocusSample = self.textSample
end

function ColorConfiguratorSaveDialog:onOpen()
	self.textElement:setText(g_i18n:getText(ColorConfiguratorSaveDialog.L10N_SYMBOL.DEFAULT_COLOR_NAME))

	ColorConfiguratorSaveDialog:superClass().onOpen(self)
end

function ColorConfiguratorSaveDialog:sendCallback(clickOk)
	local text = self.textElement.text
	local isVehicleConfig = self.isVehicleConfig

	self:close()

	if clickOk then
		self.colorConfigurator.dialog:onSaveConfig(text, isVehicleConfig)
	end
end

function ColorConfiguratorSaveDialog:onClickSaveOption(state)
	self.isVehicleConfig = state == ColorConfiguratorSaveDialog.SAVE_STATE.VEHICLE
end

function ColorConfiguratorSaveDialog:onEnterPressed(element, dismissal)
end

function ColorConfiguratorSaveDialog:updateButtonVisibility()
end