--[[
Copyright (C) Achimobil, 2022

Author: Achimobil
Date: 23.06.2022
Version: 0.1.0.0

Contact:
https://discord.gg/Va7JNnEkcW(Achimobil)

History:
V 0.1.0.0 @ 23.06.2022 - First Version

Important:
Written based on functions of giants and other scripts as reference to be able to use in multiple own mods.
It is not allowed to copy in own mods without permission from me (Achimobil).
Generall usage for the Hot Online team is permitted by me. 

Make the usage of the following possible:
- designMaterial{i}Configurations
- design{i}Configurations
both up to number 16

Extends the max configuration options which are usable at all to 256

Warning:
Using more than 16 each can cause heavy errors in transfer. 
The maximum number is with this sript 256 configs including all ohter configs like wheels, motors and so on.
So keep your fingers away from this script because you have no permission to change it and no knowledge what you do. 
]]

AdditionalDesignConfigsSpecialization = {
    prerequisitesPresent = function()
        return true
    end,
    Version = "0.1.0.0",
    Name = "AdditionalDesignConfigsSpecialization"
}

print(g_currentModName .. " - init " .. AdditionalDesignConfigsSpecialization.Name .. "(Version: " .. AdditionalDesignConfigsSpecialization.Version .. ")");

function AdditionalDesignConfigsSpecialization.initSpecialization()
    -- Increase max configuration options to 256
    ConfigurationUtil.SEND_NUM_BITS = 8;

    local schema = Vehicle.xmlSchema;
    for i = 9, 16 do
        local name = string.format("design%d", i);
        if g_configurationManager.configurations[name] == nil then
            g_configurationManager:addConfigurationType(name, g_i18n:getText("configuration_design"), nil, nil, ConfigurationUtil.getConfigColorSingleItemLoad, ConfigurationUtil.getConfigColorPostLoad, ConfigurationUtil.SELECTOR_MULTIOPTION);
            ConfigurationUtil.registerColorConfigurationXMLPaths(schema, name);
            ObjectChangeUtil.registerObjectChangeXMLPaths(schema, string.format("vehicle.design%dConfigurations.design%dConfiguration(?)", i, i));
        end
    end

    schema:setXMLSpecializationType("BaseMaterial")

    for j = 4, 16 do
        local name = string.format("designMaterial%d", j);
        if g_configurationManager.configurations[name] == nil then
            g_configurationManager:addConfigurationType(name, g_i18n:getText("configuration_designColor"), nil, nil, ConfigurationUtil.getConfigColorSingleItemLoad, ConfigurationUtil.getConfigColorPostLoad, ConfigurationUtil.SELECTOR_COLOR);
            BaseMaterial.registerBaseMaterialConfigurationsXMLPaths(schema, name);
            ConfigurationUtil.registerColorConfigurationXMLPaths(schema, name);
            ObjectChangeUtil.registerObjectChangeXMLPaths(schema, string.format("vehicle.designMaterial%dConfigurations.designMaterial%dConfiguration(?)", j, j));
        end
    end

    schema:setXMLSpecializationType();
end

function AdditionalDesignConfigsSpecialization.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", AdditionalDesignConfigsSpecialization);
end

function AdditionalDesignConfigsSpecialization:onLoad(savegame)
    for i = 9, 16 do
        local name = string.format("design%d", i);

        if self.configurations[name] ~= nil then
            ObjectChangeUtil.updateObjectChanges(self.xmlFile, string.format("vehicle.design%dConfigurations.design%dConfiguration", i, i), self.configurations[name], self.components, self)
        end
    end

    for j = 4, 16 do
        local name = string.format("designMaterial%d", j);

        if self.configurations[name] ~= nil then
            self:applyBaseMaterialConfiguration(self.xmlFile, name, self.configurations[name]);
            ObjectChangeUtil.updateObjectChanges(self.xmlFile, string.format("vehicle.designMaterial%dConfigurations.designMaterial%dConfiguration", j, j), self.configurations[name], self.components, self);
        end
    end
end