ColorConfiguratorSliderElement = {}

local ColorConfiguratorRenderElement_mt = Class(ColorConfiguratorSliderElement, BitmapElement)

function ColorConfiguratorSliderElement.new(target, custom_mt)
	local self = BitmapElement.new(target, custom_mt or ColorConfiguratorRenderElement_mt)

	self.sliderElement = nil

	return self
end

function ColorConfiguratorSliderElement:addElement(element)
	ColorConfiguratorSliderElement:superClass().addElement(self, element)

	if element:isa(SliderElement) then
		self.sliderElement = element
	end
end

function ColorConfiguratorSliderElement:mouseEvent(posX, posY, isDown, isUp, button, eventUsed)
	if self:getIsActive() then
		if ColorConfiguratorSliderElement:superClass().mouseEvent(self, posX, posY, isDown, isUp, button, eventUsed) then
			eventUsed = true
		end

		local cursorInElement = GuiUtils.checkOverlayOverlap(posX, posY, self.sliderElement.absPosition[1], self.sliderElement.absPosition[2], self.sliderElement.absSize[1], self.sliderElement.absSize[2])

		if cursorInElement then
			if isDown and button == Input.MOUSE_BUTTON_LEFT or Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) or Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) then
				if self.handleFocus and self:getOverlayState() ~= GuiOverlay.STATE_FOCUSED then
					FocusManager:setFocus(self)
				end
			end

			if not isUp and not self.mouseEntered then
				if self:getOverlayState() == GuiOverlay.STATE_NORMAL then
					FocusManager:setHighlight(self)
				end

				self.mouseEntered = true
			end
		else
			self:restoreOverlayState()
			self.mouseEntered = false

			FocusManager:unsetHighlight(self)
		end
	end

	return eventUsed
end

function ColorConfiguratorSliderElement:getIsActive()
	local baseActive = ColorConfiguratorSliderElement:superClass().getIsActive(self)

	return baseActive and self.sliderElement ~= nil and not self.target.sceneRender.mouseDown
end

function ColorConfiguratorSliderElement:canReceiveFocus()
	return not self:getIsDisabled() and self:getIsVisible() and self:getHandleFocus()
end

function ColorConfiguratorSliderElement:getFocusTarget(incomingDirection, moveDirection)
	return self
end